#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

int cmp(const void *a, const void *b) {
    ll x = *(ll *)a;
    ll y = *(ll *)b;
    if (x < y) return -1;
    if (x > y) return 1;
    return 0;
}

int main() {
    int N;
    scanf("%d", &N);

    ll *diag1 = (ll *)malloc(N * sizeof(ll)); // x - y
    ll *diag2 = (ll *)malloc(N * sizeof(ll)); // x + y

    for (int i = 0; i < N; i++) {
        ll x, y;
        scanf("%lld %lld", &x, &y);
        diag1[i] = x - y;
        diag2[i] = x + y;
    }

    qsort(diag1, N, sizeof(ll), cmp);
    qsort(diag2, N, sizeof(ll), cmp);

    ll result = 0;

 
    for (int i = 0; i < N; ) {
        int j = i;
        while (j < N && diag1[j] == diag1[i]) j++;
        ll k = j - i;
        result += k * (k - 1); 
        i = j;
    }

 
    for (int i = 0; i < N; ) {
        int j = i;
        while (j < N && diag2[j] == diag2[i]) j++;
        ll k = j - i;
        result += k * (k - 1);
        i = j;
    }

    printf("%lld\n", result);

    free(diag1);
    free(diag2);
    return 0;
}